/*
Copyright (C) 2010 Edge-Core Networks
This software file (the "File") is owned and distributed by 
Edge-Core Networks under the following licensing terms.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston,
MA 02111-1307 USA
*/
#include <common.h>
#include "ams_lib.h"

static int global_log_level = 4;

int vsprintf(char *buf, const char *fmt, va_list args);

static int vprintk(const char *fmt, va_list args)
{
    int printed_len, log_level;
    char *p;
    static char printk_buf[4096];


    /* Emit the output into the temporary buffer */
    printed_len = vsprintf(printk_buf, fmt, args);

    if (printed_len > 0)
    {
        p = printk_buf;
        
        if (printed_len > 0 && p[0] == '<' && p[1] >= '0'
            && p[1] <= '9' && p[2] == '>')
        {
            log_level = (p[1] - '0') & ((int)0 - 1);
            p = &p[3];
            printed_len -= 3;

        }
        else 
        {
            log_level = DEFAULT_LOG_LEVEL;
        }

        if ((log_level <= global_log_level) && (printed_len > 0))
        {
            puts(p);
            return printed_len;
        }
    }
    return 0;
}

int printk(const char *fmt, ...)
{
    va_list args;
    int r;

    va_start(args, fmt);
    r = vprintk(fmt, args);
    va_end(args);

    return r;
}

/* Purpose: encrypt string
 * Input/Output:	data --- data which needs to encrypt
 * Return:	TRUE or FALSE
 * Notes:
 *	
 */
int AMS_Encrypt(char * data)
{
    char charset[] = "abcdefghijklmnopqrstuvwxyz1234567890";
    int i, index, charsetLen, dataLen;

    charsetLen = strlen(charset);
    dataLen = strlen(data);

    for(i=0; i<dataLen; i++)
    {
       index = data[i]%(char)charsetLen;
       data[i] = charset[index];
    }

    return 0;
}


